/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package maratonacps2020;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Henrique
 */
public class Romana {

    public static void main(String[] args) throws IOException {

        String temp[];

        int cont = 0;

        String linha = null;

        BufferedReader entrada = null;

        PrintWriter saida = null;

        try {
            entrada = new BufferedReader(new InputStreamReader(System.in));
            saida = new PrintWriter(new FileWriter("romana.sol"));
        } catch (FileNotFoundException ex) {
            Logger.getLogger(Romana.class.getName()).log(Level.SEVERE, null, ex);
        }

        while ((linha = entrada.readLine()) != null) {

            if (linha.equals("0")) {
                break;
            }

            temp = linha.split("\\+");

            int soma = 0;

            for (int y = 0; y < temp.length; y++) {
                soma += ConvRomDec(temp[y]);
            }

            String resultado = ConvDecRom(soma);
            
            System.out.println(resultado);
            saida.println(resultado);
        }

        if (entrada != null) {
            entrada.close();
        }
        
        if (saida != null) {
            saida.close();
        }
        System.exit(0);
    }

    public static String ConvDecRom(int n) {
        int nums[] = {1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String lets[] = {"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        String romano = "";  // O numeral romano.
        for (int i = 0; i < nums.length; i++) {
            while (n >= nums[i]) {
                romano += lets[i];
                n -= nums[i];
            }
        }
        return romano;
    }

    public static int ConvRomDec(String romano) {

        if (romano.length() == 0) {
            throw new NumberFormatException("Uma string vazia não é um numeral romano.");
        }

        romano = romano.toUpperCase();

        int i = 0;       // Uma posição na string do numeral;
        int arabico = 0;  // Numeral Arábico equivalente a parte da string que já tiver sido convertida

        while (i < romano.length()) {

            char let = romano.charAt(i);        // Uma letra em determinda posição da string
            int num = letToNum(let);  // Numeral equivalente à letra.

            if (num < 0) {
                throw new NumberFormatException("Caractere Ilegal \"" + let + "\" em números romanos.");
            }

            i++;  // Move para a próxima posição na string

            if (i == romano.length()) {
                // Não há uma letra na string na sequência daquela que acabamos de processar
                // Assim, apenas adicionamos o número correspondente a uma única letra em arábico.
                arabico += num;
            } else {
                int proxNum = letToNum(romano.charAt(i));
                if (proxNum > num) {
                    // Combinar duas letras para ter um único valor, e avança para a próxima posição na string
                    arabico += (proxNum - num);
                    i++;
                } else {
                    // Não há combinação de letras. Apenas adiciona o valor de uma letra ao número.
                    arabico += num;
                }
            }
        }

        if (arabico > 3999) {
            throw new NumberFormatException("Numeral Romano só pode ter valores até 3999.");
        }

        return arabico;

    }

    public static int letToNum(char let) {
        // Converter uma letra em numeral arábico
        switch (let) {
            case 'I':
                return 1;
            case 'V':
                return 5;
            case 'X':
                return 10;
            case 'L':
                return 50;
            case 'C':
                return 100;
            case 'D':
                return 500;
            case 'M':
                return 1000;
            default:
                return -1;
        }
    }
}
